% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankScatterPlot.R
\name{rankScatterPlot}
\alias{rankScatterPlot}
\title{Rank Scatter Plot}
\usage{
rankScatterPlot(object, p.col = "black", p.size = 1.5, p.shape = 19,
                lab = TRUE, lab.col = "red", lab.size = 3.88,
                ref.line = TRUE, max.overlaps = 10, max.tick = 50,
                ref.lab = "Reference ranking", alt.lab = "Alternative ranking",
                combine = FALSE, nr = NULL, nc = NULL)
}
\arguments{
\item{object}{an object of class \code{"rankComp"}, usually, an output of a call
to \code{\link{rankComp}}.}

\item{p.col}{point color code. See \sQuote{Color Specification}
in \code{\link{par}}.}

\item{p.size}{point size value.}

\item{p.shape}{point shape value. See \sQuote{pch values} in \code{\link{points}}.}

\item{lab}{a logical value indicating whether identifier labels should be
assigned to scatter points. If \code{object$id} is \code{NULL}, the points
will be labeled by the row index.}

\item{lab.col}{color code for labels. See \sQuote{Color Specification} in
\code{\link{par}}.}

\item{lab.size}{label size value.}

\item{ref.line}{a logical value indicating whether a 45-degree reference line
should be added to the plot.}

\item{max.overlaps}{a value to exclude the label if it has too many overlaps.
The default value is \code{10}. Set \code{max.overlaps = Inf} to always show all
labels.}

\item{max.tick}{a positive integer to control the maximum number of axis
ticks. The default value is \code{50}. Set \code{max.tick} equal to or greater than
the number of rankings to display all rankings on the axis.}

\item{ref.lab}{name of the reference index.}

\item{alt.lab}{name of the alternative index.}

\item{combine}{a logical value indicating whether to generate a grid that
combines plots from different time factors (If \code{object$time} is not \code{NULL}).}

\item{nr}{(optional) number of rows in the plot grid.}

\item{nc}{(optional) number of columns in the plot grid.}
}
\value{
A scatter plot displaying unit rankings for two indices. In case \code{object$time}
is not \code{NULL}, a list of plots for different time factors and the combined
grid (if \code{combine = TRUE}) will be returned. The function does not print the
return if it is assigned to an object. Use \code{\link{print}} with the storing object
to generate the plot.
}
\description{
Generate rank scatter plots for ranking comparison.
}
\examples{
data(bli)

# Goalpost normalization
bli.pol = c("neg", "pos", "pos", "pos", "pos", "neg",
            "pos", "pos", "pos", "neg", "pos")
bli.norm.2014 <- normalize(inds = bli[, 3:13], method = "goalpost",
                           ind.pol = bli.pol, time = bli$YEAR,
                           ref.time = 2014)

# Composite indices
ci.gini <- giniCI(bli.norm.2014, method = "gini",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)
ci.reci <- giniCI(bli.norm.2014, method = "reci", agg = "geo",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)

# Ranking comparison plots
ci.comp <- rankComp(ci.gini, ci.reci, id = bli$COUNTRY, time = bli$YEAR)
rankScatterPlot(ci.comp)$'2014'
rankShiftPlot(ci.comp)$'2015'
rankRankPlot(ci.comp)$'2016'

# Storing and printing
p.scatter <- rankScatterPlot(ci.comp, combine = TRUE, max.overlaps = 20)
print(p.scatter$'2017') # or: print(p.scatter[[4]])
print(p.scatter$'comb') # or: print(p.scatter[[5]])
}
\seealso{
\code{\link{rankComp}}, \code{\link{rankShiftPlot}}, \code{\link{rankRankPlot}}.
}
\author{
Viet Duong Nguyen, Chiara Gigliarano, Mariateresa Ciommi
}
