% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankShiftPlot.R
\name{rankShiftPlot}
\alias{rankShiftPlot}
\title{Rank Shift Plot}
\usage{
rankShiftPlot(object, p.cols = c("black", "red"), p.shapes = c(1, 8),
              p.sizes = c(1.5, 1.5), s.col = "black",
              s.type = 1, s.width = 0.5, max.tick = 50,
              ref.lab = "Reference ranking", alt.lab = "Alternative ranking",
              y.lab = "Ranking", combine = FALSE, nr = NULL, nc = NULL)
}
\arguments{
\item{object}{an object of class \code{"rankComp"}, usually, an output of a call
to \code{\link{rankComp}}.}

\item{p.cols}{a vector with two elements denoting the color codes for
reference and alternative positions. See \sQuote{Color Specification} in
\code{\link{par}}.}

\item{p.shapes}{a vector with two elements denoting the shapes for reference
and alternative positions. See \sQuote{pch values} in \code{\link{points}}.}

\item{p.sizes}{a vector with two elements denoting the sizes for reference
and alternative positions.}

\item{s.col}{color code for rank shift segments. See \sQuote{Color
Specification} in \code{\link{par}}.}

\item{s.type}{line type for rank shift segments. See \sQuote{Line Type
Specification} in \code{\link{par}}.}

\item{s.width}{line width for rank shift segments.}

\item{max.tick}{a positive integer to control the maximum number of axis
ticks. The default value is \code{50}. Set \code{max.tick} equal to or greater than
the number of rankings to display all rankings on the axis.}

\item{ref.lab}{name of the reference index.}

\item{alt.lab}{name of the alternative index.}

\item{y.lab}{label of the y-axis.}

\item{combine}{a logical value indicating whether to generate a grid that
combines plots from different time factors (If \code{object$time} is not \code{NULL}).}

\item{nr}{(optional) number of rows in the plot grid.}

\item{nc}{(optional) number of columns in the plot grid.}
}
\value{
A plot displaying shifts in ranking between two indices. In case \code{object$time}
is not \code{NULL}, a list of plots for different time factors and the combined
grid (if \code{combine = TRUE}) will be returned. The function does not print the
return value if it is assigned to an object. Use \code{\link{print}} with the storing
object to produce the plot.
}
\description{
Generate rank shift plots for ranking comparison.
}
\examples{
data(bli)

# Goalpost normalization
bli.pol = c("neg", "pos", "pos", "pos", "pos", "neg",
            "pos", "pos", "pos", "neg", "pos")
bli.norm.2014 <- normalize(inds = bli[, 3:13], method = "goalpost",
                           ind.pol = bli.pol, time = bli$YEAR,
                           ref.time = 2014)

# Composite indices
ci.gini <- giniCI(bli.norm.2014, method = "gini",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)
ci.reci <- giniCI(bli.norm.2014, method = "reci", agg = "geo",
                  ci.pol = "pos", time = bli$YEAR, ref.time = 2014,
                  only.ci = TRUE)

# Ranking comparison plots
ci.comp <- rankComp(ci.gini, ci.reci, id = bli$COUNTRY, time = bli$YEAR)
rankScatterPlot(ci.comp)$'2014'
rankShiftPlot(ci.comp)$'2015'
rankRankPlot(ci.comp)$'2016'

# Storing and printing
p.scatter <- rankScatterPlot(ci.comp, combine = TRUE, max.overlaps = 20)
print(p.scatter$'2017') # or: print(p.scatter[[4]])
print(p.scatter$'comb') # or: print(p.scatter[[5]])
}
\seealso{
\code{\link{rankComp}}, \code{\link{rankScatterPlot}}, \code{\link{rankRankPlot}}.
}
\author{
Viet Duong Nguyen, Chiara Gigliarano, Mariateresa Ciommi
}
