% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_googleads.R
\name{fetch_googleads}
\alias{fetch_googleads}
\title{Fetch Google Ads
Fetch data from 'Google Ads' via 'windsor.ai' API}
\usage{
fetch_googleads(
  api_key,
  date_from = NULL,
  date_to = NULL,
  fields = c("source", "campaign", "clicks", "medium", "sessions", "spend")
)
}
\arguments{
\item{api_key}{Your api key to access Windsor.ai API}

\item{date_from}{The date from which to start getting data in format YYYY-MM-DD}

\item{date_to}{The date until which to start getting data in format YYYY-MM-DD}

\item{fields}{he fields fetched from the API for a given connector
See https://www.windsor.ai/api-fields/ for details.}
}
\value{
A data frame with the desired data
}
\description{
Fetch Google Ads
Fetch data from 'Google Ads' via 'windsor.ai' API
}
\examples{
\dontrun{
# api_key needs to be provided by the user.
my_googleads_data <- fetch_googleads(api_key = "your api key",
date_from = "2022-10-01",
date_to = "2022-10-02",
fields = c("campaign", "clicks",
"spend", "impressions", "date"))
}
}
