% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_methods.R
\name{analyze_entities}
\alias{analyze_entities}
\title{analyze_entities}
\usage{
analyze_entities(text_body, flatten = TRUE)
}
\arguments{
\item{text_body}{The text string to send to the API.}

\item{flatten}{If \code{TRUE} (default), then the results of each method are flattened and converted to a data frame.}
}
\value{
A list containing two elements: \code{entities} and \code{language}.

If \code{flatten} is \code{TRUE}, then the \code{entities} element is converted to a data frame.
}
\description{
Send a request, and retrieve the \code{entities} and \code{language} responses.
This function retrieves the results from the \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeEntities}{analyzeEntities} method.
}
\examples{
\dontrun{
sample_entities <- analyze_entities(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
                                    flatten = TRUE)
sample_entities$entities
sample_entities$language
}

}
