% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_methods.R
\name{annotate_text}
\alias{annotate_text}
\title{annotate_text}
\usage{
annotate_text(text_body, flatten = TRUE)
}
\arguments{
\item{text_body}{The text string to send to the API.}

\item{flatten}{If \code{TRUE} (default), then the results of each method are flattened and converted to a data frame.}
}
\value{
A list containing five elements: \code{sentences}, \code{tokens}, \code{entities}, \code{documentSentiment}, and \code{language}.

If \code{flatten} is \code{TRUE}, then the \code{sentences}, \code{tokens}, \code{entities}, and \code{documentSentiment} elements are each converted to data frames.
}
\description{
Send a request, and retrieve the \code{sentences}, \code{tokens}, \code{entities}, \code{documentSentiment}, and \code{language} responses.
This function calls the \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/annotateText}{annotateText} method, which performs the \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeSyntax}{analyzeSyntax}, \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeEntities}{analyzeEntities}, and \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeSentiment}{analyzeSentiment} methods all within one API call.
}
\examples{
\dontrun{
sample_annotate <- annotate_text(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
                                 flatten = TRUE)
sample_annotate$sentences
sample_annotate$tokens
sample_annotate$entities
sample_annotate$documentSentiment
sample_annotate$language
}

}
