% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.convert_with_rules.R
\name{gpb.convert_with_rules}
\alias{gpb.convert_with_rules}
\title{Data preparator for GPBoost datasets with rules (integer)}
\usage{
gpb.convert_with_rules(data, rules = NULL)
}
\arguments{
\item{data}{A data.frame or data.table to prepare.}

\item{rules}{A set of rules from the data preparator, if already used. This should be an R list,
where names are column names in \code{data} and values are named character
vectors whose names are column values and whose values are new values to
replace them with.}
}
\value{
A list with the cleaned dataset (\code{data}) and the rules (\code{rules}).
        Note that the data must be converted to a matrix format (\code{as.matrix}) for input in
        \code{gpb.Dataset}.
}
\description{
Attempts to prepare a clean dataset to prepare to put in a \code{gpb.Dataset}.
             Factor, character, and logical columns are converted to integer. Missing values
             in factors and characters will be filled with 0L. Missing values in logicals
             will be filled with -1L.

             This function returns and optionally takes in "rules" the describe exactly
             how to convert values in columns.

             Columns that contain only NA values will be converted by this function but will
             not show up in the returned \code{rules}.
}
\examples{
\donttest{
data(iris)

str(iris)

new_iris <- gpb.convert_with_rules(data = iris)
str(new_iris$data)

data(iris) # Erase iris dataset
iris$Species[1L] <- "NEW FACTOR" # Introduce junk factor (NA)

# Use conversion using known rules
# Unknown factors become 0, excellent for sparse datasets
newer_iris <- gpb.convert_with_rules(data = iris, rules = new_iris$rules)

# Unknown factor is now zero, perfect for sparse datasets
newer_iris$data[1L, ] # Species became 0 as it is an unknown factor

newer_iris$data[1L, 5L] <- 1.0 # Put back real initial value

# Is the newly created dataset equal? YES!
all.equal(new_iris$data, newer_iris$data)

# Can we test our own rules?
data(iris) # Erase iris dataset

# We remapped values differently
personal_rules <- list(
  Species = c(
    "setosa" = 3L
    , "versicolor" = 2L
    , "virginica" = 1L
  )
)
newest_iris <- gpb.convert_with_rules(data = iris, rules = personal_rules)
str(newest_iris$data) # SUCCESS!
}
}
