% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hm_summary.R
\name{hm_summary}
\alias{hm_summary}
\title{Head and Mayer consistent summary statistics}
\usage{
hm_summary(model, robust = FALSE, ...)
}
\arguments{
\item{model}{(Type: lm) Regression object obtained by using the estimation methods from this package
or a generic method such as \code{lm} or \code{glm}.
Some particular classes (\code{gpml}, \code{nbpml}, \code{negbin} and \code{nls}) don't return R squared and
F statistic.}

\item{robust}{(Type: logical) Determines whether a robust
variance-covariance matrix should be used. By default is set to \code{FALSE}.

If set \code{TRUE} the estimation results are consistent with the
Stata code provided at the website
\href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook}
when choosing robust estimation.}

\item{...}{additional arguments to be passed to \code{tobit}.}
}
\value{
Summary \code{lm} object.
}
\description{
Summary of estimates function that, if is used with default options, provides estimation results are
consistent with the Stata methods used in \insertCite{Head2014;textual}{gravity}. This function is adapted from the work of
\href{https://github.com/IsidoreBeautrelet/}{Isidore Beautrelet}.
}
\examples{
# Example for CRAN checks:
# Executable in < 5 sec
library(dplyr)
data("gravity_no_zeros")

# Choose 5 countries for testing
countries_chosen <- c("AUS", "CHN", "GBR", "BRA", "CAN")
grav_small <- filter(gravity_no_zeros, iso_o \%in\% countries_chosen)

# Using OLS for testing
fit <- ols(
  dependent_variable = "flow",
  distance = "distw",
  additional_regressors = c("rta", "contig", "comcur"),
  income_origin = "gdp_o",
  income_destination = "gdp_d",
  code_origin = "iso_o",
  code_destination = "iso_d",
  uie = FALSE,
  robust = FALSE,
  data = grav_small
)

fit2 <- hm_summary(fit, robust = FALSE)
}
