% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpv.R
\name{gpv}
\alias{gpv}
\title{Generalized Path Value}
\usage{
gpv(sociomatrix, path, p = Inf, node_costs = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}

\item{p}{a nonnegative real number that sets the 'p-norm' parameter for 
generalized path value calculation.}

\item{node_costs}{a list of costs, in order, of all nodes represented in the 
sociomatrix, all are assumed 0 if unspecified}
}
\description{
Calculates the generalized path value of a user-specified path through 
\code{sociomatrix}. Parameter \code{p} sets the p-norm used in calculation.
}
\details{
As a rule of thumb, p close to 0 will downweight the impact of particular
tie strengths and upweight the impact of binary path length. p equal to 
infinity will recapitulate the traditional path value measure of Peay (1980)
and is therefore the default. In other words, the value of a path under 
\code{p = Inf} will be the value of the weakest tie. The value of the same
path under \code{p = 0} will be the inverse of its binary length.
}
\examples{
## Calculate gpv along a path in a sociomatrix
gpv(YangKnoke01, path = c(1,2,5), p = 1)

## The same calculation, with nonzero node costs
gpv(YangKnoke01, path = c(1,2,5), p = 1, node_costs = c(1,3,3,2,1))

## This path doesn't exist
gpv(YangKnoke01, path = c(1,2,4,5), p = 0)

}
\seealso{
\code{\link{opt_gpv}} to identify the path of optimal 'gpv' between two nodes 
    and \code{\link{all_opt_gpv}} to identify the optimal paths between all pairs of 
    nodes. Calling \code{\link{generate_proximities}} with \code{mode = 'gpv'} 
    returns a matrix 'gpv' values for the optimal paths between all pairs of 
    nodes.
}
