% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_plot.R
\name{predict_plot}
\alias{predict_plot}
\title{Plot estimated functions both at estimated and predicted time points with 95\% credible intervals.}
\usage{
predict_plot(
  object = NULL,
  units_label = NULL,
  type_label = c("fitted", "predicted"),
  time_points = NULL,
  date_label = NULL,
  x.axis.label = NULL,
  y.axis.label = NULL,
  single_unit = FALSE,
  credible = TRUE
)
}
\arguments{
\item{object}{A \code{gpdpgrow.predict} or \code{gmrfdpgrow.predict} object, obtained from 
\code{predict_functions(object,...)}.}

\item{units_label}{A vector of labels to apply to experimental units with length equal to the number of
unique units.  Defaults to sequential numeric values as input with data, \code{y}.}

\item{type_label}{A character vector assigning a "fitted" or "predicted
label for the \code{time_points} input. Defaults to \code{type_label = c("fitted","predicted")}.}

\item{time_points}{A list input of length 2 with each entry containing a numeric vector
of times -  one for the observed times for the set of "fitted" functions and the other denotes 
time values at which "predicted" values were rendered for the functions.  This input variable
only applies to \code{gpdpgrow} objects and not \code{gmrfdpgrow} objects because the latter 
covariance structure is based on adjacency for equally-spaced time points.
Defaults to \code{1:T_train} for the list entry pointed to "fitted" and 
\code{(T_train+1):(T_train + T_test)} for the list entry pointed to "predicted".}

\item{date_label}{A vector of \code{Date} values for labeling the x-axis tick marks.
Defaults to \code{1:T}  .}

\item{x.axis.label}{Text label for x-axis. Defaults to \code{"time"}.}

\item{y.axis.label}{Text label for y-axis. Defaults to \code{"function values"}.}

\item{single_unit}{A scalar boolean indicating whether to plot the fitted vs data curve for
only a single experimental units (versus a random sample of 6). 
Defaults to \code{FALSE}.}

\item{credible}{A scalar boolean indicating whether to plot 95 percent credible intervals for
estimated functions, \code{bb}, when plotting fitted functions versus data.  Defaults to
\code{credible = TRUE}  .}
}
\value{
A list object containing the plot of estimated functions, faceted by cluster,
    	and the associated \code{data.frame} object.
    \item{p.cluster}{A \code{ggplot2} plot object}
    \item{dat.cluster}{A \code{data.frame} object used to generate \code{p.cluster}.}
}
\description{
Uses as input the output object from the gpdpgrow.predict() and 
gmrfdpgrow.predict() methods.
}
\examples{
\dontrun{
library(growfunctions)
data(cps)
y_short             <- cps$y[,(cps$yr_label \%in\% c(2008:2013))]
t_train             <- ncol(y_short)
N                   <- nrow(y_short)
t_test              <- 4
 
## Model Runs

res_gmrf            <- gmrfdpgrow(y = y_short, 
                                q_order = c(2,4), 
                                q_type = c("tr","sn"), 
                                n.iter = 40, 
                                n.burn = 20, 
                                n.thin = 1) 

res_gp              <- gpdpgrow(y = y_short
                              n.iter = 10, 
                              n.burn = 4, 
                              n.thin = 1, 
                              n.tune = 0) 

## Prediction Model Runs
T_test             <- 4

pred_gmrf          <- predict_functions( object = res_gmrf,
                                     J = 1000, 
                                     T_test = T_test )

T_yshort           <- ncol(y_short)
pred_gp            <- predict_functions( object = res_gp, 
                     test_times = (T_yshort+1):(T_yshort+T_test) )

## plot estimated and predicted functions
plot_gmrf       <- predict_plot(object = pred_gmrf, 
                               units_label = cps$st, 
                               single_unit = TRUE, 
                               credible = FALSE)

plot_gp         <- predict_plot(object = pred_gp, 
                               units_label = cps$st, 
                               single_unit = FALSE, 
                               credible = TRUE)  
}
}
\seealso{
\code{\link{gpdpgrow}}, \code{\link{gmrfdpgrow}}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
