% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getGroupID}
\alias{getGroupID}
\title{Get a groupID object}
\usage{
getGroupID(group)
}
\arguments{
\item{group}{A vector describing the grouping structure. It should 
contain a group id for each predictor variable.}
}
\value{
An object of class groupID, which is a list, whose members are 
   vectors of indices corresponding to each group. The names of
   the list members are the corresponding group names.
}
\description{
Mostly intended for internal use.
}
\examples{
group  <- c("A", "A", 2, 9, "A", 9, 9, 2, "A")
group.id <- getGroupID(group)
group.id
# $A
# [1] 1 2 5 9
# 
# $`2`
# [1] 3 8
# 
# $`9`
# [1] 4 6 7
# 
# attr(,"class")
# [1] "groupID"

}
