% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackman.R
\name{blackman}
\alias{blackman}
\title{Blackman window}
\usage{
blackman(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric" (Default)}{Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When "periodic" is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Blackman window, returned as a vector.
}
\description{
Return the filter coefficients of a Blackman window.
}
\details{
The Blackman window is a member of the family of cosine sum windows.
}
\examples{

h <- blackman(64)
plot (h, type = "l", xlab = "Samples", ylab =" Amplitude")

bs = blackman(64,'symmetric')
bp = blackman(63,'periodic')
plot (bs, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(bp, col="red")

}
\author{
Andreas Weingessel, \email{Andreas.Weingessel@ci.tuwien.ac.at}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
