% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackmanharris.R
\name{blackmanharris}
\alias{blackmanharris}
\title{Blackman-Harris window}
\usage{
blackmanharris(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric" (Default)}{Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When "periodic" is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Blackman-Harris window, returned as a vector.
}
\description{
Return the filter coefficients of a minimum four-term Blackman-Harris window.
}
\details{
The Blackman window is a member of the family of cosine sum windows. It is a
generalization of the Hamming family, produced by adding more shifted sinc
functions, meant to minimize side-lobe levels.
}
\examples{

b <- blackmanharris(64)
plot (b, type = "l", xlab = "Samples", ylab =" Amplitude")

bs = blackmanharris(64,'symmetric')
bp = blackmanharris(63,'periodic')
plot (bs, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(bp, col="red")

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
