% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample.R
\name{downsample}
\alias{downsample}
\title{Decrease sample rate}
\usage{
downsample(x, n, phase = 0)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{n}{downsampling factor, specified as a positive integer.}

\item{phase}{offset, specified as a positive integer from \code{0} to \code{n
- 1}. Default: 0.}
}
\value{
Downsampled signal, returned as a vector or matrix.
}
\description{
Downsample a signal by an integer factor.
}
\details{
For most signals you will want to use \code{\link{decimate}} instead since it
prefilters the high frequency components of the signal and avoids aliasing
effects.
}
\examples{
x <- seq_len(10)
xd <- downsample(x, 3)     # returns 1  4  7 10
xd <- downsample(x, 3, 2)  # returns 3 6 9

x <- matrix(seq_len(12), 4, 3, byrow = TRUE)
xd <- downsample(x, 3)

}
\seealso{
\code{\link{decimate}}, \code{\link{resample}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
