% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwht.R
\name{ifwht}
\alias{ifwht}
\alias{fwht}
\title{Fast Walsh-Hadamard Transform}
\usage{
ifwht(x, n = NROW(x), ordering = c("sequency", "hadamard", "dyadic"))

fwht(x, n = NROW(x), ordering = c("sequency", "hadamard", "dyadic"))
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal. \code{fwht} operates only on signals with length equal to a power
of 2. If the length of \code{x} is less than a power of 2, its length is
padded with zeros to the next greater power of two before processing.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}

\item{ordering}{order of the Walsh-Hadamard transform coefficients, one of:
\describe{
  \item{"sequency"}{(Default) Coefficients in order of increasing sequency
  value, where each row has an additional zero crossing.}
  \item{"hadamard"}{Coefficients in normal Hadamard order}
  \item{"dyadic"}{Coefficients in Gray code order, where a single bit change
  occurs from one coefficient to the next}
}}
}
\value{
(Inverse) Fast Walsh Hadamard transform, returned as a vector or
  matrix.
}
\description{
Compute the (inverse) Fast Walsh-Hadamard transform of a signal.
}
\examples{
x <- c(19, -1, 11, -9, -7, 13, -15, 5)
X <- fwht(x)
all.equal(x, ifwht(X))

}
\references{
\url{https://en.wikipedia.org/wiki/Hadamard_transform}

\url{https://en.wikipedia.org/wiki/Fast_Walsh-Hadamard_transform}
}
\author{
Mike Miller.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
