% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauspuls.R
\name{gauspuls}
\alias{gauspuls}
\title{Gaussian-modulated sinusoidal RF pulse}
\usage{
gauspuls(t, fc = 1000, bw = 0.5)
}
\arguments{
\item{t}{Vector of time values at which the unit-amplitude Gaussian RF pulse
is calculated.}

\item{fc}{Center frequency of the Gaussian-modulated sinusoidal pulses,
specified as a real positive scalar expressed in Hz. Default: 1000}

\item{bw}{Fractional bandwidth of the Gaussian-modulated sinusoidal pulses,
specified as a real positive scalar.}
}
\value{
Inphase Gaussian-modulated sinusoidal pulse, returned as a vector of
  unit amplitude at the times indicated by the time vector t.
}
\description{
Generate a Gaussian modulated sinusoidal pulse sampled at times \code{t}.
}
\examples{

fs <- 11025    # arbitrary sample rate
t <- seq(-10, 10, 1/fs)
yi1 <- gauspuls(t, 0.1, 1)
yi2 <- gauspuls(t, 0.1, 2)
plot(t, yi1, type="l", xlab = "Time", ylab = "Amplitude")
lines(t, yi2, col = "red")

fs <- 11025  # arbitrary sample rate
f0 <- 100    # pulse train sample rate
x <- pulstran (seq(0, 4/f0, 1/fs), seq(0, 4/f0, 1/f0), "gauspuls")
plot (0:(length(x)-1) * 1000/fs, x, type="l",
      xlab = "Time (ms)", ylab = "Amplitude",
      main = "Gaussian pulse train at 10 ms intervals")

}
\author{
Sylvain Pelissier, Mike Miller.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
