% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmonopuls.R
\name{gmonopuls}
\alias{gmonopuls}
\title{Gaussian monopulse}
\usage{
gmonopuls(t, fc = 1000)
}
\arguments{
\item{t}{Vector of time values at which the unit-amplitude Gaussian monopulse
is calculated.}

\item{fc}{Center frequency of the Gaussian monopulses, specified as a real
positive scalar expressed in Hz. Default: 1000}
}
\value{
Samples of the Gaussian monopulse, returned as a vector of unit
  amplitude at the times indicated by the time vector \code{t}.
}
\description{
Returns samples of the unit-amplitude Gaussian monopulse.
}
\examples{
fs <- 11025    # arbitrary sample rate
t <- seq(-10, 10, 1/fs)
y1 <- gmonopuls(t, 0.1)
y2 <- gmonopuls(t, 0.2)
plot(t, y1, type="l", xlab = "Time", ylab = "Amplitude")
lines(t, y2, col = "red")
legend("topright", legend = c("fc = 0.1", "fc = 0.2"),
       lty = 1, col = c(1, 2))

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
