% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zp2tf.R
\name{zp2tf}
\alias{zp2tf}
\title{Zero-pole-gain to transfer function}
\usage{
zp2tf(z, p, g = 1)
}
\arguments{
\item{z}{complex vector of the zeros of the model}

\item{p}{complex vector of the poles of the model}

\item{g}{overall gain. Default: 1.}
}
\value{
A list of class "Arma" with the following list elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Convert digital filter zero-pole-gain data to transfer function form
}
\examples{
g <- 1
z <- c(0, 0)
p <- pracma::roots(c(1, 0.01, 1))
ba <- zp2tf(z, p, g)

}
\seealso{
\code{\link{as.Arma}}, \code{\link{filter}}
}
\author{
Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
