% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_geo_strf_dyn_height_pc}
\alias{gsw_geo_strf_dyn_height_pc}
\title{Geostrophic Dynamic Height Anomaly (Piecewise-Constant Profile)}
\usage{
gsw_geo_strf_dyn_height_pc(SA, CT, delta_p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{delta_p}{difference in sea pressure between the deep and
shallow limits of layers within which \code{SA} and \code{CT} are 
assumed to be constant. Note that \code{delta_p} must be positive.}
}
\value{
A list containing \code{dyn_height}, the dynamic height anomaly [ m^2/s^2 ], and
\code{p_mid} [ dbar ], the pressures at the layer centres. Note that the dynamic height
anomaly unit, also known as a "dynamic meter", corresponds to approximately 1.02 metres of sealevel height
(see e.g. Talley et al., 2011. Descriptive Physical Oceanography, Edition 6.
Elsevier).
}
\description{
Geostrophic Dynamic Height Anomaly (Piecewise-Constant Profile)
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
delta_p <- c(10,      40,      75,     125,     350,     400)
r <- gsw_geo_strf_dyn_height_pc(SA, CT, delta_p)
stopifnot(all.equal(r$dyn_height, c(-0.300346215853487, -1.755165998114308, -4.423531083131365,
                                    -6.816659136254657, -9.453175257818430, -12.721009624991439)))
stopifnot(all.equal(r$p_mid/1e2, c(0.050000000000000, 0.300000000000000, 0.875000000000000,
                                   1.875000000000000, 4.250000000000000, 8.000000000000000)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_geo_strf_dyn_height.html}
}
