% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dstudy.R
\name{dstudy}
\alias{dstudy}
\title{D-study (Decision)}
\usage{
dstudy(gdata, queries = gdata$n.q, stability = 0.95, alpha = 0.025)
}
\arguments{
\item{gdata}{The result of running a \code{\link{gstudy}} with existing data.}

\item{queries}{A vector with different query set sizes for which to estimate Erho2 and Phi.
Defaults to the number of queries used to compute \code{gdata}.}

\item{stability}{A vector with target Erho2 and Phi values to estimate required query set sizes.}

\item{alpha}{A vector of confidence levels to compute intervals for Erho2, Phi and query set
sizes. This is the probability on each side of the interval, so for a 90\% confidence interval
one must set \code{alpha} to 0.05.}
}
\value{
An object of class \code{\link{dstudy}}, with the following components:
\tabular{ll}{
\code{Erho2}, \code{Erho2.lwr}, \code{Erho2.upr} \tab Expected generalizability coefficient, and
  lower and upper limits of the intervals around it. \cr
\code{Phi}, \code{Phi.lwr}, \code{Phi.upr} \tab Expected index of dependability, and lower and
  upper limits of the intervals around it. \cr
\code{n.q_Erho2}, \code{n.q_Erho2.lwr}, \code{n.q_Erho2.upr} \tab Expected number of queries to
  achieve the generalizability coefficient, and lower and upper limits of the intervals around
  it. \cr
\code{n.q_Phi}, \code{n.q_Phi.lwr}, \code{n.q_Phi.upr} \tab Expected number of queries to achieve
  the index of dependability, and lower and upper limits of the intervals around it. \cr
\code{call} \tab A list with the \code{\link{gstudy}} used in this D-study, the target number of
  \code{queries}, target level of \code{stability} and \code{alpha} level for the confidence
  intervals. \cr
}
}
\description{
\code{dstudy} runs a D-study from the results of a \code{\link{gstudy}} and computes, for a
certain number of queries, the expected generalizability coefficient \code{Erho2} and index of
dependability \code{Phi}, possibly with confidence intervals. Alternatively, it can estimate the
number of queries needed to achieve a certain level of stability, also with confidence intervals.
}
\examples{
g <- gstudy(adhoc3)
dstudy(g)

# estimate stability at various query set sizes
dstudy(g, queries = seq(50, 200, 10))
# estimate required query set sizes for various stability levels
dstudy(g, stability = seq(0.8, 0.95, 0.01))
# compute both 95\% and 99\% confidence intervals
dstudy(g, stability = 0.9, alpha = c(0.05, 0.01) / 2)
# compute 1-tailed 95\% confidence intervals
dstudy(g, alpha = 0.05)
}
\references{
R.L. Brennan (2001). Generalizability Theory. Springer.

  L.S. Feldt (1965). The Approximate Sampling Distribution of Kuder-Richardson Reliability
  Coefficient Twenty. Psychometrika, 30(3):357–370.

  C. Arteaga, S. Jeyaratnam, and G. A. Franklin (1982). Confidence Intervals for Proportions of
  Total Variance in the Two-Way Cross Component of Variance Model. Communications in Statistics:
  Theory and Methods, 11(15):1643–1658.

  J. Urbano, M. Marrero and D. Martín (2013). On the Measurement of Test Collection Reliability.
  ACM SIGIR, pp. 393-402.
}
\seealso{
\code{\link{gstudy}}, \code{\link{gt2tau}}
}
\author{
Julián Urbano
}
