% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstudy.R
\name{gstudy}
\alias{gstudy}
\title{G-study (Generalizability)}
\usage{
gstudy(data, drop = 0)
}
\arguments{
\item{data}{A data frame or matrix with the existing effectiveness scores. Systems are columns
and queries are rows.}

\item{drop}{The fraction of worst-performing systems to drop from the data before analysis.
Defaults to 0 (include all systems).}
}
\value{
An object of class \code{gstudy}, with the following components:
\tabular{ll}{
\code{n.s}, \code{n.q} \tab Number of systems and number of queries of the existing data. \cr
\code{var.s}, \code{var.q}, \code{var.e} \tab Variance of the system, query, and residual
  effects. \cr
\code{em.s}, \code{em.q}, \code{em.e} \tab Mean squares of the system, query and residual
  components. \cr
\code{call} \tab A list with the existing \code{data} and the percentage of systems to
  \code{drop}.\cr
}
}
\description{
\code{gstudy} runs a G-study with the given data, assuming a fully crossed design (all systems
evaluated on the same queries). It can be used to estimate variance components, which can further
be used to run a D-study with \code{\link{dstudy}}.
}
\examples{
g <- gstudy(adhoc3)

# same, but drop the 20\% worst systems
g20 <- gstudy(adhoc3, drop = 0.2)
}
\references{
R.L. Brennan (2001). Generalizability Theory. Springer.

  J. Urbano, M. Marrero and D. Martín (2013). On the Measurement of Test Collection Reliability.
  ACM SIGIR, pp. 393-402.
}
\seealso{
\code{\link{dstudy}}
}
\author{
Julián Urbano
}
