% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_gt_api_key}
\alias{get_gt_api_key}
\title{Read the GOOGLE TRENDS FOR HEALTH API Key}
\usage{
get_gt_api_key(key = NULL)
}
\arguments{
\item{key}{The API key from your Google Developer project authorized for
Google Trends for Health API use, formatted in quotes.
A key can be acquired by requesting access at
\url{https://support.google.com/trends/contact/trends_api} and following the
setup instructions.}
}
\value{
Returns the API key that is set in the
GOOGLE_TRENDS_FOR_HEALTH_API_KEY  environment variable.
}
\description{
This function will read your GOOGLE TRENDS FOR HEALTH API key
from the environment variables.
If you do not have an \code{.Renviron} file, the function will create one
for you. If you already have an \code{.Renviron} file, the function will
append the key to your existing file, while making a backup of your
original file for recovery purposes.
}
\examples{

tryCatch(
  get_gt_api_key(),
  error = function(e) cat("You need to set up a valid key")
)

}
