% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{env_create}
\alias{env_create}
\title{Create an instance of the specified environment.}
\usage{
env_create(x, env_id)
}
\arguments{
\item{x}{An instance of class "GymClient"; this object has "remote_base" as an attribute.}

\item{env_id}{A short identifier (such as "3c657dbc") for the created environment instance. The instance_id is used in future API calls to identify the environment to be manipulated.}
}
\value{
A short identifier (such as "3c657dbc") for the created environment instance. The instance_id is used in future API calls to identify the environment to be manipulated.
}
\description{
Create an instance of the specified environment.
}
\examples{
\dontrun{
remote_base <- "http://127.0.0.1:5000"
client <- create_GymClient(remote_base)
env_id <- "CartPole-v0"
env_create(client, env_id)
}
}

