% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_request}
\alias{get_request}
\title{Submit a GET request to an OpenAI Gym server.}
\usage{
get_request(x, route, data = NULL)
}
\arguments{
\item{x}{An instance of class "GymClient"; this object has "remote_base" as an attribute.}

\item{route}{The URL path or endpoint.}

\item{data}{URL query arguments. Default value is NULL.}
}
\value{
If the response code is 200 or 204, a parsed response. Else, a server error or raised exception.
}
\description{
Submit a GET request to an OpenAI Gym server.
}
\examples{
\dontrun{
remote_base <- "http://127.0.0.1:5000"
client <- create_GymClient(remote_base)
route <- "/v1/envs/"
get_request(client, route)
}
}

