% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{transform.h2o4gpu_model}
\alias{transform.h2o4gpu_model}
\title{Transform a Dataset using Trained H2O4GPU Estimator}
\usage{
\method{transform}{h2o4gpu_model}(object, x, ...)
}
\arguments{
\item{object}{The h2o4gpu model object}

\item{x}{The new data where each column represents a different predictor variable to
be used in generating predictions.}

\item{...}{Additional arguments (unused for now).}
}
\description{
This function transforms the given new data using a trained H2O4GPU model.
}
\examples{
\dontrun{

library(h2o4gpu)

# Prepare data
iris$Species <- as.integer(iris$Species) # convert to numeric data

# Randomly sample 80\% of the rows for the training set
set.seed(1)
train_idx <- sample(1:nrow(iris), 0.8*nrow(iris)) 
train <- iris[train_idx, ]
test <- iris[-train_idx, ]

# Train a K-Means model
model_km <- h2o4gpu.kmeans(n_clusters = 3L) \%>\% fit(train)

# Transform test data
test_dist <- model_km \%>\% transform(test)

}
}
