% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hltm2.R
\name{hltm2}
\alias{hltm2}
\title{Hierarchical Latent Trait Models with Known Item Parameters.}
\usage{
hltm2(y, x = NULL, z = NULL, item_coefs, control = list())
}
\arguments{
\item{y}{A data frame or matrix of item responses.}

\item{x}{An optional model matrix, including the intercept term, that predicts the
mean of the latent preference. If not supplied, only the intercept term is included.}

\item{z}{An optional model matrix, including the intercept term, that predicts the
variance of the latent preference. If not supplied, only the intercept term is included.}

\item{item_coefs}{A list of known item parameters. The parameters of item \eqn{j} are given
by the \eqn{j}th element, which should be a vector of length 2, containing
the item difficulty parameter and item discrimination parameter.}

\item{control}{A list of control values
\describe{
 \item{max_iter}{The maximum number of iterations of the EM algorithm.
   The default is 150.}
 \item{eps}{Tolerance parameter used to determine convergence of the
  EM algorithm. Specifically, iterations continue until the Euclidean
  distance between \eqn{\beta_{n}} and \eqn{\beta_{n-1}} falls under \code{eps},
  where \eqn{\beta} is the vector of item discrimination parameters.
  \code{eps}=1e-4 by default.}
 \item{max_iter2}{The maximum number of iterations of the conditional
   maximization procedures for updating \eqn{\gamma} and \eqn{\lambda}.
   The default is 15.}
 \item{eps2}{Tolerance parameter used to determine convergence of the
   conditional maximization procedures for updating \eqn{\gamma} and
   \eqn{\lambda}. Specifically, iterations continue until the Euclidean
  distance between two consecutive log likelihoods falls under \code{eps2}.
  \code{eps2}=1e-3 by default.}
 \item{K}{Number of Gauss-Legendre quadrature points for the E-step. The default is 21.}
 \item{C}{[-C, C] sets the range of integral in the E-step. \code{C}=3 by default.}
}}
}
\value{
An object of class \code{hltm}.
 \item{coefficients}{A data frame of parameter estimates, standard errors,
  z values and p values.}
 \item{scores}{A data frame of EAP estimates of latent preferences and
  their approximate standard errors.}
 \item{vcov}{Variance-covariance matrix of parameter estimates.}
 \item{log_Lik}{The log-likelihood value at convergence.}
 \item{N}{Number of units.}
 \item{J}{Number of items.}
 \item{H}{A vector denoting the number of response categories for each item.}
 \item{ylevels}{A list showing the levels of the factorized response categories.}
 \item{p}{The number of predictors for the mean equation.}
 \item{q}{The number of predictors for the variance equation.}
 \item{control}{List of control values.}
 \item{call}{The matched call.}
}
\description{
\code{hltm2} fits a hierarchical latent trait model where the item parameters
  are known and supplied by the user.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
dichotomize <- function(x) findInterval(x, c(mean(x, na.rm = TRUE)))
y_bin <- y
y_bin[] <- lapply(y, dichotomize)

n <- nrow(nes_econ2008)
id_train <- sample.int(n, n/4)
id_test <- setdiff(1:n, id_train)

y_bin_train <- y_bin[id_train, ]
x_train <- x[id_train, ]
z_train <- z[id_train, ]

mod_train <- hltm(y_bin_train, x_train, z_train)

y_bin_test <- y_bin[id_test, ]
x_test <- x[id_test, ]
z_test <- z[id_test, ]

item_coefs <- lapply(coef_item(mod_train), `[[`, "Estimate")

model_test <- hltm2(y_bin_test, x_test, z_test, item_coefs = item_coefs)
}
