% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.hIRT}
\alias{summary.hIRT}
\alias{print.summary_hIRT}
\title{Summarizing Hierarchical Item Response Theory Models}
\usage{
\method{summary}{hIRT}(object, by_item = FALSE, digits = 3, ...)

\method{print}{summary_hIRT}(x, digits = 3, ...)
}
\arguments{
\item{object}{An object of class \code{hIRT}.}

\item{by_item}{Logical. Should item parameters be stored item by item
(if \code{TRUE}) or put together in a data frame (if \code{FALSE})?}

\item{digits}{the number of significant digits to use when printing.}

\item{...}{further arguments passed to \code{\link{print}}.}

\item{x}{An object of class \code{hIRT}}
}
\value{
An object of class \code{summary_hIRT}.
 \item{call}{The matched call.}
 \item{model}{Model fit statistics: Log likelihood, AIC, and BIC.}
 \item{item_coefs}{Item parameter estimates, standard errors,
  z values, and p values.}
 \item{mean_coefs}{Parameter estimates for the mean equation.}
 \item{var_coefs}{Parameter estimates for the variance equation.}
}
\description{
Summarizing the fit of either \code{hltm} or \code{hgrm}.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
summary(nes_m1, by_item = TRUE)
}
