% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_hal9001.R
\name{h}
\alias{h}
\title{HAL Formula term: Generate a single term of the HAL basis}
\usage{
h(
  ...,
  k = NULL,
  s = NULL,
  pf = 1,
  monotone = c("none", "i", "d"),
  . = NULL,
  dot_args_as_string = FALSE,
  X = NULL
)
}
\arguments{
\item{...}{Variables for which to generate multivariate interaction basis
function where the variables can be found in a matrix \code{X} in a parent
environment/frame. Note, just like standard \code{formula} objects, the
variables should not be characters (e.g. do h(W1,W2) not h("W1", "W2"))
h(W1,W2,W3) will generate three-way HAL basis functions between W1, W2, and
W3. It will \code{not} generate the lower dimensional basis functions.}

\item{k}{The number of knots for each univariate basis function used to
generate the tensor product basis functions. If a single value then this
value is used for the univariate basis functions for each variable.
Otherwise, this should be a variable named list that specifies for each
variable how many knots points should be used.
\code{h(W1,W2,W3, k = list(W1 = 3, W2 = 2, W3=1))} is equivalent to first
binning the variables \code{W1}, \code{W2} and \code{W3} into \code{3}, \code{2} and \code{1} unique
values and then calling \code{h(W1,W2,W3)}. This coarsening of the data ensures
that fewer basis functions are generated, which can lead to substantial
computational speed-ups. If not provided and the variable \code{num_knots}
is in the parent environment, then \code{s} will be set to
\code{num_knots}`.}

\item{s}{The \code{smoothness_orders} for the basis functions. The possible
values are \code{0} for piece-wise constant zero-order splines or \code{1} for
piece-wise linear first-order splines. If not provided and the variable
\code{smoothness_orders} is in the parent environment, then \code{s} will
be set to \code{smoothness_orders}.}

\item{pf}{A \code{penalty.factor} value the generated basis functions that is
used by \code{glmnet} in the LASSO penalization procedure. \code{pf = 1}
(default) is the standard penalization factor used by \code{glmnet} and
\code{pf = 0} means the generated basis functions are unpenalized.}

\item{monotone}{Whether the basis functions should enforce monotonicity of
the interaction term. If \verb{\code{s} = 0}, this is monotonicity of the
function, and, if \verb{\code{s} = 1}, this is monotonicity of its derivative
(e.g., enforcing a convex fit). Set \code{"none"} for no constraints, \code{"i"} for
a monotone increasing constraint, and \code{"d"} for a monotone decreasing
constraint. Using \code{"i"} constrains the basis functions to have positive
coefficients in the fit, and \code{"d"} constrains the basis functions to have
negative coefficients.}

\item{.}{Just like with \code{formula}, \code{.} as in \code{h(.)} or \code{h(.,.)} is
treated as a wildcard variable that generates terms using all variables in
the data. The argument \code{.} should be a character vector of variable
names that \code{.} iterates over. Specifically,
\code{h(., k=1, . = c("W1", "W2", "W3"))} is equivalent to
\code{h(W1, k=1) + h(W2, k=1) + h(W3, k=1)}, and
\code{h(., .,  k=1, . = c("W1", "W2", "W3"))} is equivalent to
\code{h(W1,W2, k=1) + h(W2,W3, k=1) + h(W1, W3, k=1)}}

\item{dot_args_as_string}{Whether the arguments \code{...} are characters or
character vectors and should thus be evaluated directly. When \code{TRUE}, the
expression h("W1", "W2") can be used.}

\item{X}{An optional design matrix where the variables given in \code{...}
can be found. Otherwise, \code{X} is taken from the parent environment.}
}
\description{
HAL Formula term: Generate a single term of the HAL basis
}
