% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_eval.R
\name{har_eval}
\alias{har_eval}
\title{Evaluation of event detection}
\usage{
har_eval()
}
\value{
\code{har_eval} object
}
\description{
Hard evaluation of event detection producing confusion matrix and common
metrics (accuracy, precision, recall, F1, etc.).
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

dataset <- examples_anomalies$simple
head(dataset)

# Configure a change-point detector (GARCH)
model <- hcp_garch()

# Fit the detector
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected events
print(detection[(detection$event),])

# Evaluate detections
evaluation <- evaluate(har_eval(), detection$event, dataset$event)
print(evaluation$confMatrix)

# Plot the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)

}
\references{
\itemize{
\item Salles, R., Lima, J., Reis, M., Coutinho, R., Pacitti, E., Masseglia, F., Akbarinia, R.,
Chen, C., Garibaldi, J., Porto, F., Ogasawara, E. SoftED: Metrics for soft evaluation of
time series event detection. Computers and Industrial Engineering, 2024.
doi:10.1016/j.cie.2024.110728
}
}
