% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_spawn.R
\name{predict_spawn}
\alias{predict_spawn}
\title{Predict spawning of fish}
\usage{
predict_spawn(data, dates, temperature, develop.date, model)
}
\arguments{
\item{data}{Data frame with dates and temperature.}

\item{dates}{Date of temperature measurements.}

\item{temperature}{Temperature measurements.}

\item{develop.date}{Date of development (e.g., hatch or emergence), given as
a character string (e.g., "1990-08-18"). Must be year-month-day in format
shown.}

\item{model}{A data.frame with a column named "expression" or a character vector
giving model specifications. Can be obtained using \code{model_select()}
or using you own data to obtain a model expression (see \code{fit_model}).}
}
\value{
A list with the following elements:
\itemize{
\item \code{days_to_develop}: A numeric vector of length 1; number of predicted
days to hatch or emerge.
\item \code{ef_table}: An n x 4 tibble (n = number of days to hatch or emerge) with
the dates, temperature, effective values, and cumulative sum of the
effective values. Presented in descending order from devlop.date backward.
\item \code{dev_period}: a 1x2 dataframe with the dates corresponding to when your
fish's parent spawned (input with \code{predict_phenology(spawn.date = ...)})
and the date when the fish is predicted to hatch or emerge.
\item \code{model_specs}: A data.frame with the model specifications.
}
}
\description{
Predict the spawning of fish using the backwards calculation of the
effective value framework.
}
\examples{
library(hatchR)
# get emergence mod for bull trout
bull_trout_emerge_mod <- model_select(author = "Austin et al. 2019",
                                      species = "bull trout",
                                      model = "MM",
                                      development_type = "emerge"
)

# predict spawn date using emergence date
predict_spawn(data = crooked_river,
              dates = date,
              temperature = temp_c,
              develop.date = "2015-03-21",
              model = bull_trout_emerge_mod
)
}
\references{
Sparks, M.M., Falke, J.A., Quinn, T.A., Adkinson, M.D.,
Schindler, D.E. (2019). Influences of spawning timing, water temperature,
and climatic warming on early life history phenology in western
Alaska sockeye salmon.
\emph{Canadian Journal of Fisheries and Aquatic Sciences},
\bold{76(1)}, 123--135.
}
