# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @export Model
NULL

#' @export Exponential
NULL

#' @export SymmetricExponential
NULL

#' @export PowerLaw
NULL

#' @export Pareto3
NULL

#' @export Pareto2
NULL

#' @export Pareto1
NULL

#' @export Gaussian
NULL

#' Incomplete gamma function of imaginary argument with arbitrary power
#'
#' Calculates the value of
#' \deqn{-ix e^{ix} E_\theta(ix) = -ix e{ix} \int_1^\infty t^{-\theta} e^{-ixt} \mathrm d t}
#' for \eqn{\theta > 0}.
#' This is achieved using recursive integrations by parts until \eqn{0 < \theta \le 1},
#' then using either the exponential integral `E1_imaginary` if \eqn{\theta = 1},
#' or the incomplete gamma function `inc_gamma_imag` if \eqn{0 < \theta < 1}.
#'
#' @param theta A strictly positive number
#' @param x A vector of non-negative numbers
#'
#' @return The incomplete gamma function of imaginary argument with arbitrary power (see Details)
#' @export
#'
#' @examples
#' Etheta_imaginary(3.14, 1.0)
Etheta_imaginary <- function(theta, x) {
    .Call('_hawkesbow_Etheta_imaginary', PACKAGE = 'hawkesbow', theta, x)
}

#' Incomplete gamma function of imaginary argument
#'
#' Calculates the value of
#' \deqn{\Gamma_1(x, \alpha) = \int_x^\infty t^{\alpha-1} e^{-it} \mathrm{d}t}
#' for \eqn{0 < \alpha < 1} through the following relations:
#' \deqn{\int_0^\infty t^{\alpha-1} e^{-it} \mathrm{d}t =
#' e^{-i\frac{\pi}{2}\alpha} \int_0^\infty t^{\alpha-1} e^{-t} \mathrm{d}t =
#' e^{-i\frac{\pi}{2}\alpha} \Gamma(\alpha).}
#' obtained by contour integration, and:
#' \deqn{\int_0^x t^{\alpha-1} e^{-it} \mathrm{d}t =
#' \int_0^x t^{\alpha-1} \mathrm{cos}(t) \mathrm{d}t -
#' i \int_0^x t^{\alpha-1} \mathrm{sin}(t) \mathrm{d}t =
#' Ci(x, \alpha) - i Si(x, \alpha)}.
#' The first integral is calculated using function "tgamma" from the library
#' "boost::math", while the functions Ci and Si are approximated via
#' Taylor expansions.
#'
#' @param x A non-negative number
#' @param alpha A number between 0 and 1 (strictly)
#'
#' @return The incomplete gamma function of imaginary argument (see Details)
#' @export
#'
#' @examples
#' inc_gamma_imag(1.0, 0.5)
inc_gamma_imag <- function(x, alpha) {
    .Call('_hawkesbow_inc_gamma_imag', PACKAGE = 'hawkesbow', x, alpha)
}

#' Exponential integral of imaginary argument
#'
#' Calculates the value of
#' \deqn{E_1(ix) = \int_1^\infty \frac{e^{-ixt}}{t} \mathrm{d}t}
#' using its relation to the trigonometric integrals
#' (cf. \url{https://en.wikipedia.org/wiki/Exponential_integral#Exponential_integral_of_imaginary_argument}):
#' \deqn{E_1(ix) = i \left[ -\frac{1}{2} \pi + Si(x) \right] - Ci(x)}
#' and their Pad\'e approximants
#' (cf. \url{https://en.wikipedia.org/wiki/Trigonometric_integral#Efficient_evaluation})
#'
#' @param x A non-negative number
#'
#' @return The exponential integral of argument ix
#' @export
#'
#' @examples
#' E1_imaginary(1.0)
E1_imaginary <- function(x) {
    .Call('_hawkesbow_E1_imaginary', PACKAGE = 'hawkesbow', x)
}

