% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRGBArray.R
\name{plotRGBArray}
\alias{plotRGBArray}
\title{Plotting an RGB array on the graphics.}
\usage{
plotRGBArray(rgbArray, xlim = c(0, 1), ylim = c(0, 1), ...)
}
\arguments{
\item{rgbArray}{RGB array (W x H x 3) where the third dimension contains R, G and B channels, values varying from 0 to 1.}

\item{xlim}{range of the x axis.}

\item{ylim}{range of the y axis.}

\item{...}{graphical parameters passed to the plot function}
}
\value{
a rasterImage output plotted on the base R graphics.
}
\description{
Plotting an RGB array on the graphics.
}
\examples{
library(jpeg)
img <- readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
plotRGBArray(img)
}
\seealso{
\code{\link{plotRGBArray}} wraps the \code{graphics::rasterImage} function
}
