% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.plot}
\alias{HDCATE.plot}
\title{Plot HDCATE function and the uniform confidence bands}
\usage{
HDCATE.plot(
  HDCATE_model,
  output_pdf = FALSE,
  pdf_name = "hdcate_plot.pdf",
  include_band = TRUE,
  test_side = "both",
  y_axis_min = "auto",
  y_axis_max = "auto",
  display.hdcate = "HDCATEF",
  display.ate = "ATE",
  display.siglevel = "sig_level"
)
}
\arguments{
\item{HDCATE_model}{an object created via \link{HDCATE}}

\item{output_pdf}{if \code{TRUE}, the plot will be saved as a PDF file, the default is \code{FALSE}}

\item{pdf_name}{file name when \code{output_pdf=TRUE}}

\item{include_band}{if \code{TRUE}, plot the uniform confidence bands (need: \link{HDCATE.inference} was called before)}

\item{test_side}{\code{'both'}, \code{'left'} or \code{'right'}, i.e. 2-side test or one-side test}

\item{y_axis_min}{minimum value of the Y axis to plot in the graph, the default is \code{auto}}

\item{y_axis_max}{maximum value of the Y axis to plot in the graph, the default is \code{auto}}

\item{display.hdcate}{the name of HDCATE function in the legend, the default is 'HDCATEF'}

\item{display.ate}{the name of average treatment effect in the legend, the default is 'ATE'}

\item{display.siglevel}{the name of the significant level for confidence bands in the legend, the default is 'sig_level'}
}
\value{
None. A plot will be shown or saved as PDF.
}
\description{
Plot HDCATE function and the uniform confidence bands
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

HDCATE.set_condition_var(model, 'X2', min=-1, max=1, step=0.01)
\donttest{
HDCATE.fit(model)
HDCATE.inference(model)
HDCATE.plot(model)
}
}
