% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cov_qis.R
\name{get_cov_qis}
\alias{get_cov_qis}
\title{Quadratic-inverse shrinkage}
\usage{
get_cov_qis(data, k = -1)
}
\arguments{
\item{data}{(n*p): raw data matrix of n iid observations on p random
variables}

\item{k}{If k < 0, then the algorithm demeans the data by default, and
adjusts the effective sample size accordingly. If the user inputs k = 0,
then no demeaning takes place; if user inputs k = 1, then it signifies that
the data data have already been demeaned.}
}
\value{
sigmahat (p*p): the QIS covariance matrix estimate. An object of
class \code{matrix}.
}
\description{
Nonlinear shrinkage derived under Frobenius loss and its two cousins,
Inverse Stein’s loss and Minimum Variance loss, called quadratic-inverse
shrinkage (QIS). See Ledoit and Wolf (2022, Section 4.5).
}
