% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{discount}
\alias{discount}
\title{Discount a Quantity Over Time. Should be a scalar if time is
specified, a vector otherwise}
\usage{
discount(x, r, first = FALSE, period = 1, linear = FALSE, time)
}
\arguments{
\item{x}{numeric. A quantity to discount.}

\item{r}{discount rate.}

\item{first}{logical. Should discounting start at the
first value?}

\item{period}{Number of cycle per unit of discount rate.}

\item{linear}{logical. Should the discount rate vary linearly along the
whole period?}

\item{time}{The cycle number.}
}
\value{
A numeric vector of the same length as \code{x}.
}
\description{
Discount a Quantity Over Time. Should be a scalar if time is
specified, a vector otherwise
}
\details{
If the unit of discount rate is the year and a cycle duration is 1
month, period should be 12.
}
\examples{

discount(rep(10, 5), .02)
discount(rep(10, 5), .02, first = FALSE)
 
discount(1000, .05, time = 10)
discount(1000, .05, period = 2, time = 1:10)
discount(1000, .05, period = 2, time = 1:10, linear = TRUE)

}
\keyword{internal}
