% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_custom.R
\name{causal_custom}
\alias{causal_custom}
\title{Custom map profile}
\usage{
causal_custom(
  FUN = mean,
  attribute,
  units = "",
  color_scale = "RdPu",
  color_edges = "red4",
  ...
)
}
\arguments{
\item{FUN}{A summary function to be called on the process time of a specific activity, e.g. mean, median, min, max}

\item{attribute}{The name of the case attribute to visualize (should be numeric)}

\item{units}{Character to be placed after values (e.g. EUR for monetary euro values)}

\item{color_scale}{Name of color scale to be used for nodes. Defaults to RdPu See \code{Rcolorbrewer::brewer.pal.info()} for all options.}

\item{color_edges}{The color used for edges. Defaults to red4.}

\item{...}{Additional arguments forwarded to FUN}
}
\description{
Function to create a custom map profile based on some event log attribute.
}
\details{
If used for edges, it will show the attribute values which related to the out-going node of the edge.
}
\examples{
causal_net(L_heur_1,
           type_nodes = causal_custom(attribute = "timestamp"),
           type_edges = causal_custom(attribute = "timestamp"))

}
