% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparametric_sdr.R
\name{phd}
\alias{phd}
\title{PHD SDR fitting function}
\usage{
phd(x, y, d = 5L)
}
\arguments{
\item{x}{an n x p matrix of covariates, where each row is an observation and each column is a predictor}

\item{y}{vector of responses of length n}

\item{d}{an integer representing the structural dimension}
}
\value{
A list with the following elements
\itemize{
\item beta.hat estimated sufficient dimension reduction matrix
\item eta.hat coefficients on the scale of the scaled covariates
\item cov variance covariance matric for the covariates
\item sqrt.inv.cov inverse square root of the variance covariance matrix for the covariates. Used for scaling
\item M matrix from principal Hessian directions
\item eigenvalues eigenvalues of the M matrix
}
}
\description{
fits SDR models (PHD approach)
}
