% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdosage.R
\name{fs.dosage}
\alias{fs.dosage}
\alias{fst.dosage}
\alias{fis.dosage}
\alias{pairwise.fst.dosage}
\alias{plot.fs.dosage}
\alias{print.fs.dosage}
\title{Estimates F-statistics from dosage data}
\usage{
fs.dosage(dos, pop, matching = FALSE)

\method{plot}{fs.dosage}(x, ...)

\method{print}{fs.dosage}(x, digits = 4, ...)

fst.dosage(dos, pop, matching = FALSE)

fis.dosage(dos, pop, matching = FALSE)

pairwise.fst.dosage(dos, pop, matching = FALSE)
}
\arguments{
\item{dos}{either a matrix with snps columns and individuals in rows containing allelic dosage (number [0,1 or 2] of alternate alleles); 
or a square matrix with as many rows and columns as the number of individuals and containing the proportion of matching alleles}

\item{pop}{a vector containing the identifier of the population to which the individual in the corresponding row belongs}

\item{matching}{logical:TRUE if dos is a square matrix of allelic matching; FALSE otherwise}

\item{x}{a fs.dosage object}

\item{...}{further arguments to pass}

\item{digits}{number of digits to print}
}
\value{
Fi list of individual inbreeding coefficients, estimated with the reference being the population to which the individual belongs.

FsM matrix containing population specific FSTs on the diagonal. The off diagonal elements contains the average of the kinships 
for pairs of individuals, one from each population, relative to the mean kinship for pairs of individuals between populations.

Fst2x2 matrix containing pairwise FSTs

Fs The first row contains population specific and overall Fis, the second row population specific 
(average \eqn{\hat{\beta_{ST}^i}} over loci)  FSTs and overall Fst \eqn{\hat{\beta_{ST}}} (see Table 3 of 
\href{https://academic.oup.com/genetics/article/206/4/2085/6072590}{Weir and Goudet, 2017 (Genetics)})
}
\description{
Reports individual inbreeding coefficients, Population specific and pairwise Fsts, and Fiss from dosage data
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot function for fs.dosage class

\item \code{print}: Print function for fs.dosage class
}}

\examples{
\dontrun{
 dos<-matrix(sample(0:2,size=10000,replace=TRUE),ncol=100)
 fs.dosage(dos,pop=rep(1:5,each=20))
 plot(fs.dosage(dos,pop=rep(1:5,each=20)))
}

}
\seealso{
\code{\link{betas}}
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}

\href{https://academic.oup.com/genetics/article/206/4/2085/6072590}{Weir, BS and Goudet J. 2017} A Unified Characterization 
of Population Structure and Relatedness. Genetics (2017) 206:2085
}
