% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksGRM.R
\name{kinshipShift}
\alias{kinshipShift}
\title{Shifts a kinship matrix}
\usage{
kinshipShift(x,shift=NULL)
}
\arguments{
\item{x}{a square matrix}

\item{shift}{the amount by which the elements of x should be shifted. if \code{shift==NULL}, 
the average of the off-diagonal elements is substracted}
}
\value{
the shifted kinship matrix \eqn{\frac{x-shift}{1-shift}}
}
\description{
Shifts a kinship matrix
}
\details{
The kinship matrix produced by \code{beta.dosage} is relative to the average kinship
of the set of individuals analysed (\eqn{1/(n(n-1)/2) \sum_i \sum_{j>i} x_{ij}=0}). 
Another reference point might be useful, for instance to avoid negative kinship values, one might
want to shift the matrix by \eqn{min(x_{ij}), i \neq j}.
}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}
}
