% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api-add.R
\name{hc_add_dependency}
\alias{hc_add_dependency}
\title{Add modules or plugin dependencies to highcharts objects}
\usage{
hc_add_dependency(hc, name = "plugins/annotations.js")
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{name}{The partial path to the plugin or module,
example: \code{"plugins/annotations.js"}}
}
\description{
Add modules or plugin dependencies to highcharts objects
}
\details{
See \code{vignette("modules")}
}
\examples{

data(mpg, package = "ggplot2")

hchart(mpg, "point", hcaes(displ, hwy),
  regression = TRUE,
  regressionSettings = list(type = "polynomial", order = 5, hideInLegend = TRUE)
) \%>\%
  hc_add_dependency("plugins/highcharts-regression.js")

hchart(mpg, "point", hcaes(displ, hwy, group = drv), regression = TRUE) \%>\%
  hc_colors(c("#d35400", "#2980b9", "#2ecc71")) \%>\%
  hc_add_dependency("plugins/highcharts-regression.js")
}
