% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_caption}
\alias{hc_caption}
\title{Caption options for highcharter objects}
\usage{
hc_caption(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highcharts/caption}.}
}
\description{
The chart's caption, which will render below the chart and will be part
of exported charts. The caption can be updated after chart initialization
through the Chart.update or Chart.caption.update methods.
}
\examples{

highchart() \%>\%
  hc_title(text = "Chart with a caption") \%>\%
  hc_subtitle(text = "This is the subtitle") \%>\%
  hc_xAxis(categories = c("Apples", "Pears", "Banana", "Orange")) \%>\%
  hc_add_series(
    data = c(1, 4, 3, 5),
    type = "column",
    name = "Fruits"
  ) \%>\%
  hc_caption(
    text = "<b>The caption renders in the bottom, and is part of the exported
    chart.</b><br><em>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
    sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim
    ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip
    ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate
    velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat
    cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est
    laborum.</em>'"
  )
}
