% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hchart.R
\name{hchart.survfit}
\alias{hchart.survfit}
\title{Plot survival curves using Highcharts}
\usage{
\method{hchart}{survfit}(
  object,
  ...,
  fun = NULL,
  markTimes = TRUE,
  symbol = "plus",
  markerColor = "black",
  ranges = FALSE,
  rangesOpacity = 0.3
)
}
\arguments{
\item{object}{A survfit object as returned from the \code{survfit} function}

\item{...}{Extra parameters to pass to \code{hc_add_series} function}

\item{fun}{Name of function or function used to transform the survival curve:
\code{log} will put y axis on log scale, \code{event} plots cumulative events
(f(y) = 1-y), \code{cumhaz} plots the cumulative hazard function (f(y) =
-log(y)), and \code{cloglog} creates a complimentary log-log survival plot
(f(y) = log(-log(y)) along with log scale for the x-axis.}

\item{markTimes}{Label curves marked at each censoring time? TRUE by default}

\item{symbol}{Symbol to use as marker (plus sign by default)}

\item{markerColor}{Color of the marker ("black" by default); use NULL to use
the respective color of each series}

\item{ranges}{Plot interval ranges? FALSE by default}

\item{rangesOpacity}{Opacity of the interval ranges (0.3 by default)}
}
\value{
Highcharts object to plot survival curves
}
\description{
Plot survival curves using Highcharts
}
\examples{

# Plot Kaplan-Meier curves
require("survival")
leukemia.surv <- survfit(Surv(time, status) ~ x, data = aml)
hchart(leukemia.surv)

# Plot the cumulative hazard function
lsurv2 <- survfit(Surv(time, status) ~ x, aml, type = "fleming")
hchart(lsurv2, fun = "cumhaz")

# Plot the fit of a Cox proportional hazards regression model
fit <- coxph(Surv(futime, fustat) ~ age, data = ovarian)
ovarian.surv <- survfit(fit, newdata = data.frame(age = 60))
hchart(ovarian.surv, ranges = TRUE)
}
