% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.cut.R
\name{do.cut}
\alias{do.cut}
\title{Apply Cuts to the Reference Matrix}
\usage{
do.cut(mat, cuts, type = "combined")
}
\arguments{
\item{mat}{the matrix to cut}

\item{cuts}{a list of cuts generated using \code{\link{make.cut}}}

\item{type}{the type of cuts to use (use \code{combined} by default)}
}
\value{
a matrix of the same dimensionality as \code{mat} where values correspond to bins defined by the \code{type}
        thresholds defined \code{cuts}.
}
\description{
Apply cuts generated using the \code{\link{make.cut}} function to the reference matrix
}
\details{
The matrix can be cut using either the fixed cuts (\code{type='fixed'}), or the combined cuts (\code{type='combined'})
where the limits have been adjusted to match local minima and maxima.
Returned values correspond to the bin defined between the first and second threshold of the specified \code{cuts},
then between the second and third threshold, and so on. The values will range between 0 (the first bin) and \code{n-1} where
\code{n} is the number of values in the specified \code{cuts}.
}
\examples{
# generate a random 3D matrix with 2 peaks
mat <- rbind(matrix(rnorm(300),ncol=3),
             matrix(rnorm(300,5,1),ncol=3))
dimnames(mat)[[2]] <- LETTERS[1:3]
# estimate the Hilbert order
hilbert.order(mat)
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
}
\author{
Yann Abraham
}
