% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hilbertMapping}
\alias{hilbertMapping}
\title{Map High Dimensional Coordinates to Hilbert Index and back}
\arguments{
\item{x}{a matrix of a matrix of integer coordinates (see \code{\link{do.hilbert}})}

\item{bits}{the hilbert order, \emph{i.e.} the number of cuts in each dimension}
}
\value{
a vector of hilbert index, one for each line in \code{x}
}
\description{
\code{hilbertMapping} will compute the \href{https://en.wikipedia.org/wiki/Hilbert_curve}{Hilbert index} for each
row of a matrix of integer coordinates corresponding to sub-cubes in a high dimensional space.
}
\details{
Functions: TransposetoAxes AxestoTranspose
Purpose: Transform in-place between Hilbert transpose and geometrical axes
Example: b=5 bits for each of n=3 coordinates.
15-bit Hilbert integer = A B C D E F G H I J K L M N O is stored
as its Transpose
X[0] = A D G J M X[2]|
X[1] = B E H K N <-------> | /X[1]
X[2] = C F I L O axes |/
high low 0------ X[0]
Axes are stored conventionally as b-bit integers.
Author: John Skilling 20 Apr 2001 to 11 Oct 2003

The source code includes the correction suggested in the following
\href{https://stackoverflow.com/a/10384110}{StackOverflow discussion}.
}
\author{
Marilisa Neri

Yann Abraham

John Skilling
}
