% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hglm.R
\name{hglm_model}
\alias{hglm_model}
\title{Create a HGLM Model}
\usage{
hglm_model(
  x,
  y,
  family = gaussian(),
  weights = NULL,
  frame = NULL,
  solver = "auto",
  approx = FALSE
)
}
\arguments{
\item{x}{a numeric matrix giving the design matrix.}

\item{y}{a vector giving the response variables.}

\item{family}{a description of the error distribution and link function to be used in the model.}

\item{weights}{an optional vector of 'prior weights' to be used for the estimation.}

\item{frame}{an optional model frame object.}

\item{solver}{a character string giving the name of the solver to be used for the estimation.}

\item{approx}{a logical; if \code{TRUE} uses linear approximation of log-likelihood.}
}
\value{
An object of class \code{"hglm_model"}.
}
\description{
Create a HGLM model object.
}
\details{
No standardization prior to fitting the model takes place. If a x or y standardization is wanted, the user has to do this beforehand.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
x <- model.matrix(y ~ ., data = dat)
hglm_model(x, y = dat[["y"]])
}
