% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggvenn2.R
\name{ggvenn2}
\alias{ggvenn2}
\title{A modified version of functions from the ggvenn package for plotting phylogenetic venn diagrams.}
\usage{
ggvenn2(
  data,
  columns = NULL,
  show_elements = FALSE,
  show_percentage = TRUE,
  digits = 1,
  fill_color = c("blue", "yellow", "green", "red"),
  fill_alpha = 0.5,
  stroke_color = "black",
  stroke_alpha = 1,
  stroke_size = 1,
  stroke_linetype = "solid",
  set_name_color = "black",
  set_name_size = 6,
  text_color = "black",
  text_size = 4,
  label_sep = ",",
  count_column = NULL,
  show_outside = c("auto", "none", "always"),
  auto_scale = FALSE,
  comma_sep = FALSE
)
}
\arguments{
\item{data}{A data.frame or a list as input data.}

\item{columns}{A character vector use as index to select columns/elements.}

\item{show_elements}{Show set elements instead of count/percentage.}

\item{show_percentage}{Show percentage for each set.}

\item{digits}{The desired number of digits after the decimal point}

\item{fill_color}{Filling colors in circles.}

\item{fill_alpha}{Transparency for filling circles.}

\item{stroke_color}{Stroke color for drawing circles.}

\item{stroke_alpha}{Transparency for drawing circles.}

\item{stroke_size}{Stroke size for drawing circles.}

\item{stroke_linetype}{Line type for drawing circles.}

\item{set_name_color}{Text color for set names.}

\item{set_name_size}{Text size for set names.}

\item{text_color}{Text color for intersect contents.}

\item{text_size}{Text size for intersect contents.}

\item{label_sep}{Separator character for displaying elements.}

\item{count_column}{Specify column for element repeat count.}

\item{show_outside}{Show outside elements (not belongs to any set).}

\item{auto_scale}{Allow automatically resizing circles according to element counts.}

\item{comma_sep}{Whether to use comma as separator for displaying numbers.}
}
\value{
The ggplot object to print or save to file.
}
\description{
A modified version of functions from the ggvenn package for plotting phylogenetic venn diagrams.
}
\examples{

# use list as input
a <- list(`Set 1` = c(1, 3, 5, 7),
          `Set 2` = c(1, 5, 9),
          `Set 3` = c(1, 2, 8),
          `Set 4` = c(6, 7))
ggvenn2(a, c("Set 1", "Set 2"))
ggvenn2(a, c("Set 1", "Set 2", "Set 3"))
ggvenn2(a)

}
\references{
Yan, Linlin, and Maintainer Linlin Yan. "Package “ggvenn.”." (2021).
}
\seealso{
geom_venn, ggvenn
}
