% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_cume.R
\name{nba_cumestatsplayergames}
\alias{nba_cumestatsplayergames}
\title{\strong{Get NBA Stats API Cumulative Player Game Stats}}
\usage{
nba_cumestatsplayergames(
  league_id = "00",
  location = "",
  outcome = "",
  player_id = "2544",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  vs_conference = "",
  vs_division = "",
  vs_team_id = "",
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{location}{location}

\item{outcome}{outcome}

\item{player_id}{player_id}

\item{season}{season}

\item{season_type}{season_type}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{vs_team_id}{vs_team_id}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: CumeStatsPlayerGames

\strong{CumeStatsPlayerGames}\tabular{ll}{
   col_name \tab types \cr
   MATCHUP \tab character \cr
   GAME_ID \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Cumulative Player Game Stats}

\strong{Get NBA Stats API Cumulative Player Game Stats}
}
\details{
\href{https://www.nba.com/stats/cumestats}{CUME Stats}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_cumestatsplayergames(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Cume Functions: 
\code{\link{nba_cumestatsplayer}()},
\code{\link{nba_cumestatsteamgames}()},
\code{\link{nba_cumestatsteam}()}
}
\author{
Saiem Gilani
}
\concept{NBA Cume Functions}
