% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levenetestClust.R
\name{levenetestClust}
\alias{levenetestClust}
\alias{levenetestClust.default}
\alias{levenetestClust.formula}
\title{Reweighted Levene's Test for Homogeneity of Variance in Clustered Data}
\usage{
levenetestClust(y, ...)

\method{levenetestClust}{default}(y, group, id, center = c("median", "mean"), trim = NA, ...)

\method{levenetestClust}{formula}(formula, id, data, subset, na.action, ...)
}
\arguments{
\item{y}{vector of numeric responses.}

\item{...}{further arguments to be passed to or from methods.}

\item{group}{vector or factor object defining groups.}

\item{id}{vector or factor object denoting cluster membership for \code{y} responses.}

\item{center}{The name of a function to compute the center of each group. If \code{mean}, the reweighted
group means will be used. The default \code{median} is the suggested measure of center, as it provides a more
robust test.}

\item{trim}{optional numeric argument taking values [0, 0.5] to specify the percentage trimmed mean.
Ignored if \code{center = median}.}

\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs} is a numeric variable giving the data values and
\code{rhs} a factor with two or more levels giving the corresponding groups.}

\item{data}{an optional matrix or data frame containing variables in the formula \code{formula} and \code{id}.
By default the variables are taken from \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when data contain \code{NA}s. Defaults to
\code{getOption("na.action")}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{parameter}{the degrees of freedom of the chi square distribution.}
\item{method}{a character string indicating the test performed.}
\item{data.name}{a character string giving the name of the data and the total number of clusters.}
\item{M}{the number of clusters.}
}
\description{
Performs a reweighted test for homogeneity of marginal variances across intra-cluster groups in clustered data.
Appropriate for clustered data with cluster- or group size informativeness.
}
\details{
The null hypothesis is that all levels of \code{group} have equal marginal variances.
}
\examples{
data(screen8)

## Do boys and girls have the same variability in math scores?
## Test using vectors
levenetestClust(y=screen8$math, group=screen8$gender, id=screen8$sch.id)

## Test using formula method
levenetestClust(math~gender, id=sch.id, data=screen8)

## Using 10\% trimmed mean
levenetestClust(math~gender, id=sch.id, data=screen8, center="mean", trim=.1)

}
\references{
Gregg, M., Marginal methods and software for clustered data with cluster- and group-size informativeness.
PhD dissertation, University of Louisville, 2020.
}
