% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redact.R
\name{redact}
\alias{redact}
\alias{redact_cookies}
\alias{redact_headers}
\alias{within_body_text}
\title{Remove sensitive content from HTTP responses}
\usage{
redact_cookies(response)

redact_headers(response, headers = c())

within_body_text(response, FUN)
}
\arguments{
\item{response}{An \code{httr2_response} or \code{httr2_request} object to sanitize.}

\item{headers}{For \code{redact_headers()}, a character vector of header names to
sanitize.}

\item{FUN}{For \code{within_body_text()}, a function that takes as its argument a
character vector and returns a modified version of that. This function will
be applied to the text of the response's body.}
}
\value{
All redacting functions return a well-formed \code{httr2_response}
or \code{httr2_request} object.
}
\description{
When recording requests for use as test fixtures, you don't want to include
secrets like authentication tokens and personal ids. These functions provide
a means for redacting this kind of content, or anything you want, from
responses that \code{\link[=capture_requests]{capture_requests()}} saves.
}
\details{
\code{redact_cookies()} removes cookies from \code{httr2_response} objects
and is the default redactor in \code{capture_requests()}.
\code{redact_headers()} lets you target selected request and response headers for
redaction.
\code{within_body_text()} lets you manipulate the text of the response body
and manages the parsing of the raw (binary) data in the \code{httr_response} object.

Note that if you set a redacting function, it will also be applied to requests when loading mocks. This allows you to sanitize and/or shorten URLs in your mock files.
}
\seealso{
\code{vignette("redacting", package = "httptest2")} for a detailed discussion of what these functions do and how to customize them. \code{\link[=gsub_response]{gsub_response()}} is another redactor.
}
