% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_exposure.R
\name{map_wind_exposure}
\alias{map_wind_exposure}
\title{Map counties with wind exposure}
\usage{
map_wind_exposure(
  storm,
  wind_var = "vmax_sust",
  wind_limit,
  add_track = TRUE,
  wind_source = "modeled"
)
}
\arguments{
\item{storm}{A character string giving the storm ID (e.g., "Floyd-1999")}

\item{wind_var}{A character string giving the wind variable to use. Choices
are \code{"vmax_sust"} (maximum sustained winds; default), \code{"vmax_gust"}
(maximum gust winds), \code{"sust_dur"} (minutes of sustained winds of 20 m / s
or higher) and \code{"gust_dur"} (minutes of gust winds of 20 m / s or higher).
If the Extended Best Tracks wind radii are used as the source of wind data,
the \code{"gust_dur"} option cannot be selected.}

\item{wind_limit}{A numeric vector of length one giving the minimum
wind speed (in meters per second) or duration of winds of 20 m / s or more
(in minutes) to use in the filter. The units of this variable will depend on
the user's choice for the \code{wind_var} parameter. If the Extended Best
Tracks wind radii are used as the source of the wind data, the sustained
winds will only be available for cutpoints of 34 knots, 50 knots, and 64
knots, so these values should be used (e.g., to get all counties with winds of
34 knots or higher, you could use \code{wind_limit = 17.4}, with the limit
given as a value just below 34 knots in the units meters per second).}

\item{add_track}{TRUE / FALSE of whether to add the storm's track to the map. The
default is TRUE.}

\item{wind_source}{A character string specifying the source to use for the winds. Options
are \code{"modeled"}, for estimates based on running a wind model from Best
Tracks data inputs, and \code{"ext_tracks"}, for estimates based on
the wind radii in the Extended Best Tracks data. See the help files for the
datasets \code{storm_winds} and \code{ext_tracks_wind} in the
\code{hurricaneexposuredata} package for more details on each of these sources
for wind estimates. For the gust wind estimates, these are based on applying
a gust factor of 1.49 to the sustained wind estimates in both wind data sources.}
}
\value{
Plots a map showing whether eastern US counties were exposed or
   unexposed to a specific storm based on a wind criterion.
}
\description{
Map counties as "exposed" or "unexposed" based on the criterion that the
storm had a certain wind speed (specified by \code{wind_limit}, in meters
per second).
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

map_wind_exposure(storm = "Beryl-1988", wind_limit = 15)
}
}
