% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis-api.R
\name{annotation}
\alias{annotation}
\title{Operate with annotation}
\source{
\url{https://h.readthedocs.io/en/latest/api-reference/v1/}
}
\usage{
annotation(
  annotation_id,
  action = c("fetch", "update", "delete", "flag", "hide", "show", "create"),
  ...,
  api_path = get_hs_host(),
  api_key = NULL
)
}
\arguments{
\item{annotation_id}{Annotation ID}

\item{action}{Action to process, Default: `fetch`
Hide and show action needs moderator permissions.}

\item{...}{Parameters for update annotation action, more information in hypothesis
documentation}

\item{api_path}{The hypothesis API path, can be specify by `hypothesis.api.api_path` option or
`HYPOTHESIS_API_PATH` environment variable. Default: `https://hypothes.is/api/`.}

\item{api_key}{User api key, generated on the platform.}
}
\description{
Operate with annotation
}
\examples{
\dontrun{
annotation("annotation_id")
annotation("annotation_id", action = "update", text = "updated text")
annotation("annotation_id", action = "flag")
annotation("annotation_id", action = "hide")
annotation("annotation_id", action = "show")
annotation(
  action = "create",
  uri = "https://r-world-devs.github.io/hypothesis/articles/hypothesis-api.html",
  text = "test"
)
}
}
